/*
 * Copyright (c) 2002-2007 TeamDev Ltd. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * The complete licence text can be found at
 * http://www.teamdev.com/winpack/license.jsf
 */
package teamdev.jxcapture.samples.demo;

import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Resource;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Application;

import java.io.*;
import java.util.Properties;
import java.util.Map;
import java.util.HashMap;

/**
 * @author Ikryanov Vladimir
 */
public final class ApplicationSettings {

    private static ApplicationSettings instance;

    @Resource
    private int maxDelayTime;
    @Resource
    private String[] imageFormats;
    @Resource
    private String[] formatDescriptions;
    @Resource
    private String configFileName;

    private Map imageFormatExtensions = new HashMap();

    private boolean captureToViewer = true;
    private boolean captureToFile;
    private boolean captureToClipboard;
    private boolean includeCursor;
    private boolean captureTransparentWindows;
    private boolean delayBeforeCapture;
    private boolean autoSave;

    private String templateFileName = "ScreenShot#";
    private String outputFolder = "";

    private int delayTime = 1000;
    private int imageFormatIndex;
    private int templateNumber;

    private ApplicationSettings() {
        ApplicationContext context = Application.getInstance().getContext();
        ResourceMap resourceMap = context.getResourceMap(ApplicationSettings.class);
        imageFormats = new String[resourceMap.getInteger("ApplicationSettings.imageFormats.length")];
        formatDescriptions = new String[resourceMap.getInteger("ApplicationSettings.formatDescriptions.length")];
        resourceMap.injectFields(this);

        imageFormatExtensions.put(imageFormats[0], new String[] {"png", "PNG"});
        imageFormatExtensions.put(imageFormats[1], new String[] {"jpeg", "JPEG", "jpg", "JPG"});
        imageFormatExtensions.put(imageFormats[2], new String[] {"bmp", "BMP"});
        imageFormatExtensions.put(imageFormats[3], new String[] {"gif", "GIF"});
    }

    public static ApplicationSettings getInstance() {
        return instance == null ? instance = new ApplicationSettings() : instance;
    }

    public void saveSettings() {
        Properties properties = new Properties();

        properties.setProperty(Property.CAPTURE_TO_FILE.getName(), String.valueOf(captureToFile));
        properties.setProperty(Property.CAPTURE_TO_VIEWER.getName(), String.valueOf(captureToViewer));
        properties.setProperty(Property.CAPTURE_TO_CLIPBOARD.getName(), String.valueOf(captureToClipboard));
        properties.setProperty(Property.INCLUDE_CURSOR.getName(), String.valueOf(includeCursor));
        properties.setProperty(Property.CAPTURE_TRANSPARENT_WINDOWS.getName(), String.valueOf(captureTransparentWindows));
        properties.setProperty(Property.DELAY_BEFORE_CAPTURE.getName(), String.valueOf(delayBeforeCapture));
        properties.setProperty(Property.AUTO_SAVE.getName(), String.valueOf(autoSave));

        properties.setProperty(Property.TEMPLATE_FILE_NAME.getName(), templateFileName);
        properties.setProperty(Property.OUTPUT_FOLDER.getName(), outputFolder);

        properties.setProperty(Property.DELAY_TIME.getName(), String.valueOf(delayTime));
        properties.setProperty(Property.IMAGE_FORMAT_INDEX.getName(), String.valueOf(imageFormatIndex));
        properties.setProperty(Property.TEMPLATE_NUMBER.getName(), String.valueOf(templateNumber));

        try {
            File configFile = new File(configFileName);
            OutputStream outputStream = new FileOutputStream(configFile);
            properties.storeToXML(outputStream, "JxCapture Demo Application Settings");
            outputStream.flush();
            outputStream.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadSettings() {
        Properties properties = new Properties();
        try {
            File configFile = new File(configFileName);
            if (!configFile.exists()) return;
            InputStream inputStream = new FileInputStream(configFile);
            properties.loadFromXML(inputStream);
            inputStream.close();
        } catch (Exception e) {
            e.printStackTrace();
            return;
        }

        captureToFile = Boolean.valueOf(properties.getProperty(Property.CAPTURE_TO_FILE.getName()));
        captureToViewer = Boolean.valueOf(properties.getProperty(Property.CAPTURE_TO_VIEWER.getName()));
        captureToClipboard = Boolean.valueOf(properties.getProperty(Property.CAPTURE_TO_CLIPBOARD.getName()));
        includeCursor = Boolean.valueOf(properties.getProperty(Property.INCLUDE_CURSOR.getName()));
        captureTransparentWindows = Boolean.valueOf(properties.getProperty(Property.CAPTURE_TRANSPARENT_WINDOWS.getName()));
        delayBeforeCapture = Boolean.valueOf(properties.getProperty(Property.DELAY_BEFORE_CAPTURE.getName()));
        autoSave = Boolean.valueOf(properties.getProperty(Property.AUTO_SAVE.getName()));

        templateFileName = properties.getProperty(Property.TEMPLATE_FILE_NAME.getName());
        outputFolder = properties.getProperty(Property.OUTPUT_FOLDER.getName());

        delayTime = Integer.valueOf(properties.getProperty(Property.DELAY_TIME.getName()));
        imageFormatIndex = Integer.valueOf(properties.getProperty(Property.IMAGE_FORMAT_INDEX.getName()));
        templateNumber = Integer.valueOf(properties.getProperty(Property.TEMPLATE_NUMBER.getName()));
    }

    public boolean isIncludeCursor() {
        return includeCursor;
    }

    public void setIncludeCursor(boolean includeCursor) {
        this.includeCursor = includeCursor;
    }

    public boolean isCaptureTransparentWindows() {
        return captureTransparentWindows;
    }

    public void setCaptureTransparentWindows(boolean captureTransparentWindows) {
        this.captureTransparentWindows = captureTransparentWindows;
    }

    public boolean isDelayBeforeCapture() {
        return delayBeforeCapture;
    }

    public void setDelayBeforeCapture(boolean delayBeforeCapture) {
        this.delayBeforeCapture = delayBeforeCapture;
    }

    public boolean isAutoSave() {
        return autoSave;
    }

    public void setAutoSave(boolean autoSave) {
        this.autoSave = autoSave;
    }

    public int getDelayTime() {
        return delayTime;
    }

    public void setDelayTime(int delayTime) {
        this.delayTime = delayTime;
    }

    public int getImageFormatIndex() {
        return imageFormatIndex;
    }

    public void setImageFormatIndex(int imageFormatIndex) {
        this.imageFormatIndex = imageFormatIndex;
    }

    public int getTemplateNumber() {
        return templateNumber;
    }

    public void setTemplateNumber(int templateNumber) {
        this.templateNumber = templateNumber < 0 ? 0 : templateNumber;
    }

    public String getOutputFolder() {
        return outputFolder;
    }

    public void setOutputFolder(String outputFolder) {
        this.outputFolder = outputFolder;
    }

    public String getTemplateFileName() {
        return templateFileName;
    }

    public void setTemplateFileName(String templateFileName) {
        this.templateFileName = templateFileName;
    }

    public boolean isCaptureToViewer() {
        return captureToViewer;
    }

    public void setCaptureToViewer() {
        resetCaptureToValues();
        captureToViewer = true;
    }

    public boolean isCaptureToFile() {
        return captureToFile;
    }

    public void setCaptureToFile() {
        resetCaptureToValues();
        captureToFile = true;
    }

    public boolean isCaptureToClipboard() {
        return captureToClipboard;
    }

    public void setCaptureToClipboard() {
        resetCaptureToValues();
        captureToClipboard = true;
    }

    public String[] getImageFormats() {
        return imageFormats;
    }

    public String[] getFormatExtensions(String imageFormat) {
        Object result = imageFormatExtensions.get(imageFormat);
        if (result == null) return new String[0];
        return (String[]) result;
    }

    public String[] getFormatDescriptions() {
        return formatDescriptions;
    }

    public int getMaxDelayTime() {
        return maxDelayTime;
    }

    private void resetCaptureToValues() {
        captureToViewer = false;
        captureToFile = false;
        captureToClipboard = false;
    }

    private enum Property {
        CAPTURE_TO_VIEWER,
        CAPTURE_TO_FILE,
        CAPTURE_TO_CLIPBOARD,
        INCLUDE_CURSOR,
        CAPTURE_TRANSPARENT_WINDOWS,
        DELAY_BEFORE_CAPTURE,
        AUTO_SAVE,
        DELAY_TIME,
        TEMPLATE_FILE_NAME,
        OUTPUT_FOLDER,
        IMAGE_FORMAT_INDEX,
        TEMPLATE_NUMBER;

        public String getName() {
            return toString();
        }
    }
}
